//package globalExamples;

import oracle.olapi.data.source.DataProvider;
import oracle.olapi.data.source.NumberSource;
import oracle.olapi.data.source.Source;
import oracle.olapi.data.source.StringSource;

import oracle.olapi.metadata.mdm.MdmAttribute;
import oracle.olapi.metadata.mdm.MdmHierarchy;
import oracle.olapi.metadata.mdm.MdmLevel;
import oracle.olapi.metadata.mdm.MdmLevelHierarchy;
import oracle.olapi.metadata.mdm.MdmMeasure;
import oracle.olapi.metadata.mdm.MdmPrimaryDimension;

/**
 * Complete code for Example 7-12, Getting the Share of Units Sold, in 
 * Chapter 7, Making Queries Using Source Methods, in the 
 * Oracle OLAP Developer's Guide to the  OLAP API.
 * 
 * This program uses the Context10g class, which uses the
 * CursorPrintWriter class.
 * 
 * @author Oracle Corporation
 */
public class GettingShareOfUnits 
{
  public GettingShareOfUnits()
  {
  }

  public void run(String[] args)
  {
    Context10g context = new Context10g(args, false);
    DataProvider dp = context.getDataProvider();

    context.println("Example 7-12, Getting the Share of Units Sold");

    // Get the primary dimensions and the measure.
    MdmPrimaryDimension[] mdmPrimDims = 
         context.getMdmPrimaryDimensionsByName(new String[]
                                               {"PRODUCT", 
                                                "CUSTOMER", 
                                                "CHANNEL", 
                                                "TIME"});

    MdmMeasure mdmUnits = context.getMdmMeasureByName("UNITS");

    MdmPrimaryDimension mdmProdDim = (MdmPrimaryDimension) mdmPrimDims[0];
    Source prodDim = mdmProdDim.getSource();
    
    MdmLevelHierarchy mdmProdRollup = (MdmLevelHierarchy)
                                       mdmProdDim.getDefaultHierarchy();
    // Get the Source for the default product hierarchy                                   .
    StringSource prodRollup = (StringSource) mdmProdRollup.getSource();

   // Get the Source objects for the measure and for the default hierarchies 
   // of the other dimensions.
    NumberSource units = (NumberSource) mdmUnits.getSource();
    StringSource custHier = 
               (StringSource) mdmPrimDims[1].getDefaultHierarchy().getSource();
    StringSource chanHier = 
               (StringSource) mdmPrimDims[2].getDefaultHierarchy().getSource();
    StringSource timeHier = 
               (StringSource) mdmPrimDims[3].getDefaultHierarchy().getSource();

    Source allProds = prodRollup.selectValue("PRODUCT_ROLLUP::TOTAL_PRODUCT::1");

    MdmLevel mdmProdFamilies = context.getLevelByName(mdmProdRollup, "FAMILY");
    Source prodFamilies = mdmProdFamilies.getSource();

    NumberSource totalUnits = (NumberSource) units.joinHidden(allProds);

    Source productShare = units.div(totalUnits).times(100);

    Source result = 
             productShare.join(prodFamilies)
                         .join(timeHier, "CALENDAR::YEAR::4")
                         .join(chanHier, "CHANNEL_ROLLUP::CHANNEL::2")
                         .join(custHier, "SHIPMENTS_ROLLUP::ALL_CUSTOMERS::1");

    context.commit();
    context.println("result");
    context.displayResult(result);
  }
  

  public static void main(String[] args)
  {
    new GettingShareOfUnits().run(args);
  }
}


